/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
:: Control Strategy Source Code  										   	
:: (C) 2003-2009 Woodward
:: All rights reserved
::					   										   	
::-----------------------------------------------------------------------------------------------------------
:: API Module - Global Macro Definitions
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

#ifndef __MACRODEFN_H
#define __MACRODEFN_H

/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Macro to combine two Half word variables into a single Word variable 
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
#define MAKE_WORD(a,b)   ((((uint4)(a)) << 16) + ((uint4)(b)))

/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Macro to Retrieve the Upper Half word of a Long Variable
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
#define UPPER_HWORD(a)   ((a) >> 16)

/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Macro to Retrieve the Lower Half word of a Long Variable
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
#define LOWER_HWORD(a)   ((a) & 0xFFFF)

/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Macro to Calculate the number of entries of an array 
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
#define CountOf(array)	(sizeof(array)/sizeof(array[0]))

#endif /* __MACRODEFN_H*/

